#include <Windows.h>



// Funcin que elimina el directorio especificado (OJO el directorio especificado no debe terminar con antibarra '\')
void EliminarDirectorio(const TCHAR *Path) {
    WIN32_FIND_DATA		FindInfoPoint;
	HANDLE				hFind						= NULL;
	ZeroMemory(FindInfoPoint.cFileName, sizeof(TCHAR) * 260);
	TCHAR PathBuscar[MAX_PATH];
	wcscpy(PathBuscar, Path);
	wcscat(PathBuscar, TEXT("\\*.*"));
	hFind = FindFirstFile(PathBuscar, &FindInfoPoint);
	if (hFind == INVALID_HANDLE_VALUE) return;
	do {
		if (FindInfoPoint.cFileName[0] != TEXT('.')) { 
			wcscpy(PathBuscar, Path);
			wcscat(PathBuscar, TEXT("\\"));
			wcscat(PathBuscar, FindInfoPoint.cFileName);
			if (FindInfoPoint.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) { // dir
				EliminarDirectorio(PathBuscar);
			}
			else {
//				MessageBox(NULL, PathBuscar, TEXT("Borrando :"), MB_OK);
				DeleteFile(PathBuscar);
			}
		}
	} while (FindNextFile(hFind, &FindInfoPoint) != 0);
	FindClose(hFind);
	RemoveDirectory(Path);
}


int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
	// Fase 1 : El desinstalador se ejecuta desde el directorio %archivos de programa\bubatronik\desinstaladorbubatronik.exe -EliminarBubaTronik
	//			- Preguntar si queremos des-instalar.
	//          - Advertimos que se borrara el contenido de %archivos de programa\bubatronik\ completamente (por si algun iluminado le ha metido cosas dentro, que sepa que se va a quedar sin ellas)
	//			- Ejecutar limpieza del regsitro %archivos de programa\bubatronik\bubatronik.exe - DesinstalarRegistroWindows
	//          - Copiamos este ejecutable en c:\windows
	//          - Ejecutamos c:\windows\desinstaladorbubatronik.exe -EliminarDirectorio "%archivos de programa\bubatronik"
	// Fase 2 : El desinstalador se ejecuta desde c:\windows y se dispone a eliminar todo el directorio que viene en Args[2]
	//          - Busqueda recursiva con eliminacin de archivos / directorios en %archivos de programa\bubatronik
	//          - Busqueda recursiva con eliminacin de archivos / directorios en %Program Data\bubatronik
	//          - Borrar acceso directo del escritorio
	
	bool    Fase1 = true;
	bool    Invalido = false;
	TCHAR	WinDir[MAX_PATH];
	TCHAR	DesInstalarPath[MAX_PATH];
	TCHAR	AppDataPath[MAX_PATH];
	TCHAR	EscritorioPath[MAX_PATH];
	TCHAR	TmpStr[1024];
	TCHAR	TmpStr2[1024];
	int		TotalArgs	= 0;
	// Inicializamos los strings a 0
	ZeroMemory(WinDir, sizeof(TCHAR) * MAX_PATH);
	ZeroMemory(DesInstalarPath, sizeof(TCHAR) * MAX_PATH);
	ZeroMemory(AppDataPath, sizeof(TCHAR) * MAX_PATH);
	ZeroMemory(EscritorioPath, sizeof(TCHAR) * MAX_PATH);
	ZeroMemory(TmpStr, sizeof(TCHAR) * 1024);
	ZeroMemory(TmpStr2, sizeof(TCHAR) * 1024);

	// Obtenemos la linea de commando para determinar la fase y obtener los datos necesarios
	TCHAR **Args		= CommandLineToArgvW(GetCommandLine(), &TotalArgs);

	// Obtenemos el directorio de windows
	GetWindowsDirectory(WinDir, MAX_PATH);

	if (TotalArgs > 1) { // hay argumentos (probablemnte es la fase 2)
//		MessageBox(NULL, Args[0], Args[1], MB_OK);
		// El parametro es correcto, y hay 3 argumentos en total
		if (wcscmp(Args[1], TEXT("-EliminarDirectorio")) == 0 && TotalArgs == 3)	Fase1 = false;
		else {
			// Si se ha determinado que es la fase1 miramos que el parametro sea el adecuado
			if (wcscmp(Args[1], TEXT("-EliminarBubaTronik")) != 0) {
//				MessageBox(NULL, Args[1], TEXT("-EliminarBubaTronik"), MB_OK);
				Invalido = true;
			}
		}
	}
	else {
		Invalido = true;
	}

	// Parametros invalidos, salimos
	if (Invalido == true) {
		MessageBox(NULL, TEXT("Parametros invalidos!"), TEXT("Error"), MB_OK);
		return 0;
	}


	// Fase 1
	if (Fase1 == true) {
		// Obtenemos el path del des-instalador sin la ltima antibarra
		wcscpy(DesInstalarPath, Args[0]);
		for (size_t n = wcslen(DesInstalarPath); n > 0; n--) {
			if (DesInstalarPath[n - 1] == TEXT('\\')) {
				DesInstalarPath[n - 1] = TEXT('\0');
				break;
			}
		}

		// Preguntamos si quiere des-instalar
		int RetMsg = MessageBox(NULL, TEXT("Deseas des-instalar BubaTronik de tu sistema?"), TEXT("Des-instalacin de BubaTronik"), MB_YESNO | MB_ICONEXCLAMATION);
		// Si no le da a aceptar salimos del programa
		if (RetMsg != IDYES && RetMsg != IDOK) return 0;

		// Advertimos que se borrara toda la carpeta y pedimos confirmacin
		wcscpy(TmpStr, TEXT("Atencion! se eliminara todo el contenido de "));
		wcscat(TmpStr, DesInstalarPath);
		wcscat(TmpStr, TEXT("\\, deseas continuar?"));
		RetMsg = MessageBox(NULL, TmpStr, TEXT("Des-instalacin de BubaTronik"), MB_YESNO | MB_ICONWARNING);
		// Si no le da a aceptar salimos del programa
		if (RetMsg != IDYES && RetMsg != IDOK) return 0;

		// Ejecutamos el desinstalador de datos del registro
		wcscpy(TmpStr, DesInstalarPath);
		wcscat(TmpStr, TEXT("\\BubaTronik.exe"));
		ShellExecute(NULL, TEXT("open"), TmpStr, TEXT("-DesinstalarRegistroWindows"), DesInstalarPath, SW_SHOWDEFAULT);

		// Copiamos este ejecutable en el directorio de windows
		wcscpy(TmpStr, WinDir);
		wcscat(TmpStr, TEXT("\\DesInstaladorBubaTronik.exe"));
		CopyFile(Args[0], TmpStr, FALSE);

		// Ejecutamos la fase 2 con el ejecutable de la carpeta windows
		wcscpy(TmpStr2, TEXT("-EliminarDirectorio \""));
		wcscat(TmpStr2, DesInstalarPath);
		wcscat(TmpStr2, TEXT("\""));
//		MessageBox(NULL, TmpStr, TmpStr2, MB_OK);
		ShellExecute(NULL, TEXT("open"), TmpStr, TmpStr2, WinDir, SW_SHOWDEFAULT);
	}
	// Fase 2
	else {
		Sleep(2000);

		// Borramos el directorio donde se encuentra el ejecutable de BubaTronik
		wcscpy(DesInstalarPath, Args[2]);
//		MessageBox(NULL, TEXT("FASE2"), TEXT("FASE2"), MB_OK);
//		MessageBox(NULL, DesInstalarPath, TEXT("Borrar dir \\BubaTronik"), MB_OK);
		EliminarDirectorio(DesInstalarPath);

		// Cargamos la API SHGetFolderPath con LoadLibrary, ya que el VC6 no la soporta.
		typedef HRESULT (WINAPI* TpSHGetFolderPath)(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPWSTR pszPath);
		TpSHGetFolderPath API_SHGetFolderPath;
		HMODULE Shell32 = LoadLibrary(TEXT("shell32.dll"));
		if (Shell32 != NULL) {
			API_SHGetFolderPath = reinterpret_cast<TpSHGetFolderPath>(GetProcAddress(Shell32, "SHGetFolderPathW"));
			// Obtenemos el directorio AppData
			#define VC6_CSIDL_COMMON_APPDATA            0x0023 
			API_SHGetFolderPath(NULL, VC6_CSIDL_COMMON_APPDATA, NULL, 0, AppDataPath);
			// Obtenemos el directorio del Escritorio
			#define VC6_CSIDL_COMMON_DESKTOPDIRECTORY   0x0019
			API_SHGetFolderPath(NULL, VC6_CSIDL_COMMON_DESKTOPDIRECTORY, NULL, 0, EscritorioPath);
			FreeLibrary(Shell32);
		}
		// Borramos el directorio donde se guarda la BD, la config y las actualizaciones de BubaTronik.
		wcscat(AppDataPath, TEXT("\\BubaTronik"));
//		MessageBox(NULL, AppDataPath, TEXT("Borrar dir AppData"), MB_OK);
		EliminarDirectorio(AppDataPath);

		// Borramos el acceso directo del escritorio
		wcscat(EscritorioPath, TEXT("BubaTronik.lnk"));
//		MessageBox(NULL, EscritorioPath, EscritorioPath, MB_OK);
		DeleteFile(EscritorioPath);

		MessageBox(NULL, TEXT("Des-instalacin completada."), TEXT("Des-instalacion"), MB_OK);

		// Y se acabo... por desgracia %Windows\DesInstaladorBubaTronik.exe no puede ser eliminado y se quedara inactivo en la carpeta windows
	}

	return 0;
}



